package TDAArbolBinario;
 import TDALista.Position;

/**
 * Interface BinaryTree
 * Exstiende la interfaz GTTree, presentada por Goodrich y Tamassia en su
 * cuarta edicin (la interfaz para rbol que no incluye operaciones de modificacin).
 * @author Ctedra de Estructuras de Datos, Departamento de Cs. e Ing. de la Computacin, UNS.
 */

public interface BinaryTree<E> extends GTTree<E>
{
	/**
	 * Devuelve la posicin del hijo izquierdo de v.
	 * @param v Posicin de un nodo.
	 * @return Posicin del hijo izquierdo de v.
	 * @throws InvalidPositionException si la posicin pasada por parmetro es invlida.
	 * @throws BoundaryViolationException si v no tiene hijo izquierdo.
	 */
	public Position<E> left(Position<E> v) throws InvalidPositionException, BoundaryViolationException;
	
	/**
	 * Devuelve la posicin del hijo derecho de v.
	 * @param v Posicin de un nodo.
	 * @return Posicin del hijo derecho de v.
	 * @throws InvalidPositionException si la posicin pasada por parmetro es invlida.
	 * @throws BoundaryViolationException si v no tiene hijo derecho.
	 */
	public Position<E> right(Position<E> v)throws InvalidPositionException, BoundaryViolationException;

	/**
	 * Testea si v tiene un hijo izquierdo.
	 * @param v Posicin de un nodo.
	 * @return Verdadero si v tiene un hijo izquierdo y falso en caso contrario.
	 * @throws InvalidPositionException si la posicin pasada por parmetro es invlida.	
	 */
	public boolean hasLeft(Position<E> v) throws InvalidPositionException;
	
	
	/**
	 * Testea si v tiene un hijo derecho.
	 * @param v Posicin de un nodo.
	 * @return Verdadero si v tiene un hijo derecho y falso en caso contrario.
	 * @throws InvalidPositionException si la posicin pasada por parmetro es invlida.	
	 */
	public boolean hasRight(Position<E> v) throws InvalidPositionException;
	
	/**
	 * Crea un nodo con rtulo e como raz del rbol.
	 *
	 * @param r Rtulo que se asignar a la raz del rbol.
	 * @throws InvalidOperationException si el rbol ya tiene un nodo raz.
	 */
	public Position<E> createRoot(E r) throws InvalidOperationException;
	
	
	/**
	 * Agrega un nodo con rtulo r como hijo izquierdo de un nodo dado.
	 * @param r Rtulo del nuevo nodo.
	 * @param v Posicin del nodo padre.
	 * @return La posicin del nuevo nodo creado.
	 * @throws InvalidPositionException si la posicin pasada por parmetro es invlida o el rbol est vaco.
	 * @throws InvalidOperationException si v ya tiene un hijo izquierdo.
	 */
	public Position<E> addLeft(Position<E> v, E r) throws InvalidOperationException, InvalidPositionException;


	/**
	 * Agrega un nodo con rtulo r como hijo derecho de un nodo dado.
	 * @param r Rtulo del nuevo nodo.
	 * @param v Posicin del nodo padre.
	 * @return La posicin del nuevo nodo creado.
	 * @throws InvalidPositionException si la posicin pasada por parmetro es invlida o el rbol est vaco.
	 * @throws InvalidOperationException si v ya tiene un hijo derecho.
	 */
	public Position<E> addRight(Position<E> v, E r) throws InvalidOperationException,
										InvalidPositionException;


	/**
	 * Elimina el nodo referenciado por una posicin dada. Si el nodo tiene un nico hijo, el nodo eliminado ser reemplazado por su nico hijo.
	 * @param v Posicin del nodo a eliminar.
	 * @return el rtulo del nodo eliminado.
     * @throws InvalidPositionException si la posicin pasada por parmetro es invlida o el rbol est vaco.
	 * @throws InvalidOperationException si el nodo a eliminar tiene mas de un hijo.
     */
	public E remove(Position<E> v) throws InvalidOperationException, InvalidPositionException;

	/**
	 * Inserta a los rboles T1 y T2 como subrboles hijos de la hoja v (izquierdo y derecho respectivamente).
	 * @param r Posicin de una hoja del rbol.
	 * @param T1 rbol binario a insertar como hijo izquierdo de v.
	 * @param T2 rbol binario a insertar como hijo derecho de v. 
	 * @throws InvalidPositionException si la posicin pasada por parmetro es invlida o el rbol est vaco, o v no corresponde a una hoja.
	 */
	//Pone a T1 y a T2 como subrboles de la hoja v, izquierdo y derecho respectivamente, si v no era hoja da InvalidPositionException.
	  public void attach(Position<E> r, BinaryTree<E> T1, BinaryTree<E> T2) throws InvalidPositionException;
	}